<?php
define("DOWNLOAD",  1);
define("UPLOAD",  2);
define("PUBLISH",  3);

function oauth($clientid, $secretkey, $code, $authorizationurl, $request_type, $options, $xml_file=false, $verify_peer=true) {
  error_reporting(E_ALL);

  if(!is_array($options)){
    return array('success'=>false, 'error'=>'No parameters sent in an array');
  }
  if(!isset($options['clientApp'])){$options['clientApp']='1';}

  #stuff generated from config stuff, for authorization request
  $nonce1 = mt_rand(10000000,99999999);
  $credentials = "$clientid:$nonce1"; # clientid:nonce1
  $encodedcredentials = base64_encode($credentials); # base64 encoded credentials
  $hmachash1 = hash_hmac("sha1", $encodedcredentials, $secretkey, true); # encoded credentials, signed with secret key
  $signature1 = base64_encode($hmachash1); # signed hash base64 encoded

  #stuff for download request
  $token = ''; # this will contain the result of the authorization request
  $nonce2 = mt_rand(10000000,99999999); # nonce for download request
  $timestamp = time(); # in UNIX time

  # create the data string for the authorization request and get length for Content-Length
  $request = "grant_type=authorization_code&code=$code&client_credentials=$encodedcredentials&signature=$signature1";
  $length = strlen($request);

  $ch = curl_init();
  curl_setopt($ch, CURLOPT_URL, $authorizationurl);

  curl_setopt($ch, CURLOPT_HEADER, false);
  curl_setopt($ch, CURLOPT_HTTPHEADER, array(
    "Content-Type: application/x-www-form-urlencoded", 
    "Content-Length: $length"
  ));
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
  curl_setopt($ch, CURLOPT_POST, true);
  curl_setopt($ch, CURLOPT_POSTFIELDS, $request);

  curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, $verify_peer);
  curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30);

  $json = curl_exec($ch);


  if ($json == false) {
    return array('success'=>false, 'error'=>'Curl OAUTH call failed. Curl error: '.curl_error($ch));
  }

  curl_close($ch);

  $json = json_decode($json, true);
  if (!is_array($json))
    return array('success'=>false, 'error'=>'Malformed response or bad URL');

  if (array_key_exists("error", $json)) {
    return array('success'=>false, 'error'=>"OAUTH request error: ".$json['error_description']);
  }

  switch ($request_type) {
  case DOWNLOAD:
    $endpointurl = $json['download_url'];
    break;
  case UPLOAD:
    $endpointurl = $json['upload1_url'];
    break;
  case PUBLISH:
    $endpointurl = $json['publish_url'];
    break;
  }

  # get query parameters into array, and sort alphabetically ascending
  $data = $options;

  $url_stuff = parse_url($endpointurl);
  $endpoint = $url_stuff['path'];
  $domain = $url_stuff['host'];
  $protocol = $url_stuff['scheme'];
  if(isset($url_stuff['port']))
    $port = $url_stuff['port'];
  else if(strcasecmp($protocol, 'https') == 0)
    $port = 443;
  else
    $port = 80;

  $token = $json['access_token'];
  # put the array back into an MAC-compatible string
  $imploded = "";
  ksort($data);
  foreach($data as $k=>$v) {
    $imploded.= "$k=".rawurlencode($v)."\n";
  }
  $imploded = trim($imploded,"\n");
  $macdigest = "$token\n$timestamp\n$nonce2\n\nPOST\n$domain\n$port\n$endpoint\n$imploded\n";
  $macdigesthash = hash_hmac("sha1", $macdigest, $secretkey, true);
  $signature2 = base64_encode($macdigesthash);

  $data['signature'] = $signature2;
  $data['token'] = $token;
  $data['timestamp']=$timestamp;
  $data['nonce']=$nonce2;

  $db_request = "";
  foreach ($data as $k=>$v) {
    $db_request .= "$k=$v&";
  }
  $db_request = trim($db_request, "&");

  $ch = curl_init();
  curl_setopt($ch, CURLOPT_URL, $endpointurl);

  curl_setopt($ch, CURLOPT_HEADER, false);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
  curl_setopt($ch, CURLOPT_POST, true);

  if ($request_type != UPLOAD)
    curl_setopt($ch, CURLOPT_POSTFIELDS, $db_request);
  else {
    if (array_key_exists('filename', $data)) {
      curl_setopt($ch, CURLOPT_POSTFIELDS, $db_request);
    } else {
      if (strnatcmp(phpversion(),'5.5.0') >= 0)
      {
        //For PHP version 5.5.0 and above
        $data['UploadFile'] = new \CurlFile($xml_file, 'text/xml', 'products.xml');
      } else {
        //For PHP version 5.5.0 and above
        $data['UploadFile'] = "@$xml_file;type=text/xml";
      }
      curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    }
  }

  curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, $verify_peer);
  curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30);

  $downloaddata = curl_exec($ch);
  if (!$downloaddata) {
    return array('success'=>false, 'error'=>'Curl data call failed. Curl error: '.curl_error($ch));
  }

  curl_close($ch);

  if (($json2 = json_decode($downloaddata, true)) != NULL) {
    if (array_key_exists('error', $json2)) {
      return array('success'=>false, 'error'=>"Data request error: ".$json2['error_description']);
    }
  }

  if ($request_type == UPLOAD && $data['clientApp'] < 2) {
    trigger_error('doing second upload request');
    if(array_key_exists('filename', $data)) {
      $matches = array();
      preg_match("/dbmake.cgi\?(.*)?\"/", $downloaddata, $matches);
      if (count($matches) > 1)
        $downloaddata = $matches[1];
      else
        return array('success'=>false, 'error'=>"DBupload output error, no compatible string for DBmake");
    }

    $endpointurl = $json['upload2_url'];
    $nonce3 = mt_rand(10000000,99999999);
    $timestamp3 = time();

    $pieces = explode("&", $downloaddata);
    sort($pieces);
    $imploded = implode("\n",$pieces);

    $url_stuff = parse_url($endpointurl);
    $endpoint = $url_stuff['path'];
    $domain = $url_stuff['host'];
    $protocol = $url_stuff['scheme'];
    if(isset($url_stuff['port']))
      $port = $url_stuff['port'];
    else if(strcasecmp($protocol, 'https') == 0)
      $port = 443;
    else
      $port = 80;

    $macdigest = "$token\n$timestamp3\n$nonce3\n\nPOST\n$domain\n$port\n$endpoint\n$imploded\n";
    $macdigesthash = hash_hmac("sha1", $macdigest, $secretkey, true);
    $signature3 = base64_encode($macdigesthash);
    $db_request = $downloaddata."&token=$token&timestamp=$timestamp3&nonce=$nonce3&signature=$signature3";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $endpointurl);
    curl_setopt($ch, CURLOPT_HEADER, false);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);    
    curl_setopt($ch, CURLOPT_POSTFIELDS, $db_request);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, $verify_peer);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30);
    $downloaddata = curl_exec($ch);

    if (!$downloaddata) {
      return array('success'=>false, 'error'=>'Curl dbmake call failed. Curl error: '.curl_error($ch));
    }

    if (($json2 = json_decode($downloaddata, true)) != NULL) {
      if (array_key_exists('error', $json2)) {
        return array('success'=>false, 'error'=>"DBmake request error: ".$json2['error_description']);
      }
    }

    curl_close($ch);

    return array('success'=>true);
  }

  if ($request_type == DOWNLOAD) {
    return array('success'=>true, 'data'=>$downloaddata);
  } else {
    return array('success'=>true);
  }
}

