<?php
include_once 'oauth.php';
$clientid = '';
$secretkey = '';
$code = '';
$url = '';
$version = '14.0';


  /*
  oauth($clientid, $secretkey, $code, $url, $request_mode, $options, $path_to_local_file = false, $verify_peer = true) function
  input parameters:
    $clientid: from Backoffice Applications settings
    $secretkey: from Backoffice Applications settings
    $code: from Backoffice Applications settings
    $url: from Backoffice Applications settings

    $request_mode: DOWNLOAD, UPLOAD, or PUBLISH
    $options: array('clientApp'=>'1', ...) -- array of options. clientApp => 1 is required. For other options see ShopSite help, 
      uploading: http://shopsite.com/help/11.2/en-US/sc/pro/index.htm?page=/help/11.2/en-US/sc/pro/database.automated_XML_upload.html
      downloading: http://shopsite.com/help/11.2/en-US/sc/pro/index.htm?page=/help/11.2/en-US/sc/pro/orders.download.format.xml-auto.html
      $path_to_local_file: specify for UPLOAD requests that are uploading a file located on the local server.
                           If uploading a file from ShopSite output directory, specify 'filename' option instead.
    $verify_peer: set to false to set CURLOPT_SSL_VERIFYPEER to false

  return value:
    array(
    'success': true or false
    'error': error message, present if success is false.
    'data': downloaded XML. Present for DOWNLOAD requests if success is true.
    )
   */

//get the list of available versions
/*
  $contents = oauth(
    $clientid, $secretkey, $code, $url,
    DOWNLOAD, 
    array('clientApp'=>'1', 'download_xml_versions'=>'1', 'dbname'=>'products')
  );
 */

//get the list of available fields for products and version
/*
  $contents = oauth(
    $clientid, $secretkey, $code, $url,
    DOWNLOAD, 
    array('clientApp'=>'1', 'download_fields'=>'1', 'dbname'=>'products', 'version'=>$version)
  );
 */

//download names, skus, and quantity on hand for all products
  $contents = oauth(
    $clientid, $secretkey, $code, $url,
    DOWNLOAD, 
    array('version'=>$version, 'clientApp'=>'1', 'dbname'=>'products', 'fields'=>'|Name|SKU|Quantity On Hand|')
  );

//download names, skus, and quantity on hand for products matching a search
  /*
  $contents = oauth(
    $clientid, $secretkey, $code, $url,
    DOWNLOAD, 
    array('version'=>$version, 'clientApp'=>'1', 'dbname'=>'products',
    'fields'=>'|Name|SKU|Quantity On Hand|',
    'search_on'=>'name', 'search_filter'=>'contains','search_term'=>'Aviator')
  );
   */


//download all orders
  /*
   $contents = oauth(
    $clientid, $secretkey, $code, $url,
    DOWNLOAD, 
    array('version'=>$version, 'clientApp'=>'1', 'dbname'=>'orders')
   );
   */

//Download orders after a specific date
/*
$contents = oauth(
  $clientid, $secretkey, $code, $url,
  DOWNLOAD, 
  array('clientApp'=>'1', 'version'=>$version, 'dbname'=>'orders', 'startdate'=>'11/17/2020')
);
 */

// Download orders using a merchant key
// The merchant-key.txt is the one from ShopSite > Orders > Security Options > Credit Card Storage
// Note the pay=yes to get the payment details. Merchant key isn't needed if not doing this.
/*
$keyfile = file_get_contents("merchant-key.txt");
$dkey = base64_encode($keyfile); // It should be Base64 Encoded

$contents = oauth($clientid, $secretkey, $code, $url,
     DOWNLOAD,
     array('version'=>$version,
     'clientApp'=>'1',
     'dbname'=>'orders',
     'dkey'=>$dkey,
     'pay'=>'yes')
    );
*/

//upload a file on the local server. ****** Must specify full path to file ******
/*
$contents = oauth(
  $clientid, $secretkey, $code, $url,
  UPLOAD, 
  array('clientApp'=>'2', 'version'=>$version, 'dbname'=>'products'),
  '/path/to/file/products.xml'
);
 */

/*
//upload a file already pre-uploaded to ShopSite's output directory
$contents = oauth(
  $clientid, $secretkey, $code, $url,
  UPLOAD, 
  array('clientApp'=>'1', 'dbname'=>'products', 'version'=>$version, 'filename'=>'products.xml')
);
 */

//publish
  /*$contents = oauth(
    $clientid, $secretkey, $code, $url,
    PUBLISH, 
    array('clientApp'=>'1', 'htmlpages'=>'1', 'index'=>'1')
  );*/

print_r($contents);