#!/usr/bin/perl 
#
# Copyright (C) 2004, ShopSite, Inc.
# All Rights Reserved.

# This program is an unpublished copyrighted work which is proprietary
# to ShopSite, Inc. and contains confidential information that is not
# to be reproduced or disclosed to any other person or entity without
# prior written consent from ShopSite, Inc. in each and every instance.

# WARNING:  Unauthorized reproduction of this program as well as
# unauthorized preparation of derivative works based upon the
# program or distribution of copies by sale, rental, lease or
# lending are violations of federal copyright laws and state trade
# secret laws, punishable by civil and criminal penalties.
# -------------------------------------------------------------------------*

#
# ss-dbtest.pl
#
# a sample Perl script, running as a CGI
# program.  Intended for constructing
# an appropriate CGI/"QUERY_STRING" combination.
# This CGI/"QUERY_STRING" can then be submitted
# thru an HTML form button to the appropriate
# ShopSite CGI for subsequent execution.
# 
# 2/3/2005
#
#
#	Revision History:
#		2/3/2005	- initial hack -el
#
###########################################################
use English;

# Get remote host
$ip_address = $ENV{'REMOTE_ADDR'};
@numbers = split(/\./, $ip_address);
$ip_number = pack("C4", @numbers);
($host) = (gethostbyaddr($ip_number, 2))[0];

# Create default display form on GET
 
 if ($ENV{'REQUEST_METHOD'} eq "GET") {
    $buffer = $ENV{"QUERY_STRING"};
  }

  if ($ENV{'REQUEST_METHOD'} eq "POST") {

    # GET THE INPUT FROM THE CALLING HTML DOCUMENT
    read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
  }

  ## Split the name-value pairs
  @pairs = split(/&/, $buffer);

  foreach $pair (@pairs) {
    ($name, $value) = split(/=/, $pair);
    $value =~ tr/+/ /;
    $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    $name =~ tr/+/ /;
    $name =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    $FORM{$name} = $value;
  }
  
#--------------------------
# we have a request to print
# the source code for this cgi script

  if ($FORM{"source"} eq "yes") {
    print "Content-type: text/plain\n\n";
    &print_source;
    exit(0);
  }

  print "Content-type: text/html\n\n";

  if ($ENV{'REQUEST_METHOD'} eq "GET") {
    &display_form;
    print "<pre>";
  }

#--------------------------
# display the environment variables
# for this cgi script

  if ($FORM{"display_env"} eq "display environment") {
    print "<hr><h2><u>display environment results:</u></h2>";
    foreach $key (sort keys(%ENV)) {
      print "$key = \"$ENV{$key}\"<br>";
    }
  }
  
#--------------------------
# display the html form variables
# passed to this cgi script

  if ($FORM{"display_vars"} eq "display vars") {
    print "<hr><h2><u>display vars result:</u></h2>";
    foreach $key (sort keys(%FORM)) {
      print "$key = \"$FORM{$key}\"<br>";
    }
  }
  
#--------------------------
# display the source code for this
# cgi script in an embedded frame.
# This is done to avoid having to escape
# the html codes and by specifying "plain/text"
# mime type in the download window.

  if ($FORM{"display_code"} eq "display source") {
    print "<hr><h2><u>display source code results:</u></h2>";
    print "</pre>";
    print "<IFRAME scrolling=\"auto\" src=\"$ENV{'SCRIPT_NAME'}?source=yes\"";
    print "height=\"500\" width=\"90%\"></IFRAME>";
  }
  
#-------------------------
# display databbase download results
 
  if ($FORM{"dbdown_display_http"}) {
    print "<hr><h2><u>download results:</u></h2>";
    print "</pre>";
    $outstring = $FORM{"cgi_string"} . "?";
    $outstring .= "clientApp=" . $FORM{"clientApp"};
    $outstring .= "&dbname=" . $FORM{"dbname"};
    if ($FORM{"option_1"}) {
      $outstring.= "&version=" . $FORM{"version"};
    }
    if ($FORM{"option_2"}) {
      $outstring.="&fields=" . $FORM{"fields"};
    }
    if ($FORM{"option_3"}) {
      $outstring.="&fieldmap=" . $FORM{"fieldmap"};
    }

	&print_button ($outstring);
  }
  
#-------------------------
# display database upload results
  
  if ($FORM{"dbup_display_http"}) {
    print "<hr><h2><u>upload results</u></h2>";
    print "</pre>";
    $outstring = $FORM{"cgi_string"} . "?";
    $outstring .= "clientApp=" . $FORM{"clientApp"};
    $outstring .= "&dbname=" . $FORM{"dbname"};
    if ($FORM{"option_1"}) {
      $outstring.="&filename=" . $FORM{"filename"};
    }
    if ($FORM{"option_2"}) {
      $outstring.="&uniqueName=" . $FORM{"uniqueName="};
    }
    if ($FORM{"option_3"}) {
      $outstring.="&checkpoint=" . $FORM{"checkpoint"};
    }
    if ($FORM{"option_4"}) {
      $outstring.="&newRecords=" . $FORM{"newRecords"};
    }
    if ($FORM{"option_5"}) {
      $outstring.="&use_optimizer=" . $FORM{"use_optimizer"};
    }
    if ($FORM{"option_6"}) {
      $outstring.="&defer_linking=" . $FORM{"defer_linking"};
    }
    if ($FORM{"option_7"}) {
      $outstring.="&restart=" . $FORM{"restart"};
    }

    &print_button($outstring);

  }

#--------------------------
# display database publish results

  if ($FORM{"dbgen_display_http"}) {
    print "<hr><h2><u>publish results:</u></h2>";
    print "</pre>";
    $outstring = $FORM{"cgi_string"} . "?";
    $outstring .= "clientApp=" . "1";
    if ($FORM{"option_1"}) {
      $outstring .="&htmlpages=" . "1";
    }
    if ($FORM{"option_2"}) {
      $outstring .="&custompages=" . "1";
    }
    if ($FORM{"option_3"}) {
      $outstring .="&index=" . "1";
    }
    if ($FORM{"option_4"}) {
      $outstring .="&regen=" . "1";
    }

    &print_button($outstring);
  }

#--------------------------
# routine: display_form
#
# This routine constructs the form used
# by the browser.  Embedded in the html
# is the string "$$$HTTP_HOST" which is
# replaced by the actual host name where
# this cgi is running. This is the default
# but may changed as appropriate in the text
# field provided in the form.

sub display_form {

  $_ = sprintf (<<'THE-END');
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" "http://www.w3.org/TR/REC-html40/loose.dtd">
<html>
<head>

<title>Database Automated XML Upload/Download</title>

<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1">

<script type="text/javascript" language="JavaScript1.2" src="helpnav.js"></script>
<script language="JavaScript1.2" src="popup.js"></script>
<script language="JavaScript1.2" src="glossary.js"></script>
<link rel="stylesheet" href="shopsite4nn.css" type="text/css">
<link rel="stylesheet" href="shopsite4ie.css" type="text/css" title="cst1" ID="sheet1" disabled>

<script language="JavaScript">
if (navigator.appName=="Microsoft Internet Explorer") {
  links = document.all.tags("link");
  links[0].disabled=true;
  links[1].disabled=false;
}
</script>

<style type="text/css"> <!--
	table.option {
	border: 1px black solid;
	border-collapse: collapse;
	padding: 3px;
	width: 500px;
	}
	
	th.option {
	border: 1px black solid;
	padding: 3px;
	/* width: 70px; */
	}
	
	th.description {
	border: 1px black solid;
	padding: 3px;
	/* width: 350px; */
	}
	
	th.values {
	border: 1px black solid;
	padding: 3px;
	/* width: 80px; */
	}
	
	th.input {
	border: 1px black solid;
	padding: 3px;
	background-color:#FCFFC6;
	}
	
	td.option {
	border: 1px black solid;
	vertical-align: top;
	text-align: right;
	padding: 3px;
	}
	
	td.description {
	border: 1px black solid;
	vertical-align: top;
	text-align: left;
	padding: 3px;
	}
	
	td.values {
	border: 1px black solid;
	vertical-align: middle;
	text-align: center;
	padding: 3px;
	}
	
	td.input {
	border: 1px black solid;
	vertical-align: middle;
	text-align: center;
	padding: 3px;
	background-color:#FCFFC6;
	}

-->
</style>

</head>
<body onload=window.focus() bgcolor="#ffffff">

<!-- UPDATE HISTORY --
01/13/05 - Document Creation.  MS
-- END UPDATE HISTORY -->

<p align="center"><font face="Verdana, Arial, Helvetica, sans-serif" size="-2" color="#999999"><b>
Screen: ShopSite > Utilities > Database > Upload/Download
</b></font></p>

<h2 class="Heading1">Database Automated XML Upload/Download</h2>

<p class="Body">ShopSite's programmatic XML interface allows merchants the ability to write
their own applications to automatically upload or download their store information.</p>

<table width="90%" border="0" cellpadding="5" cellspacing="0">
	<tr>
		<td valign="top" width="50" class="CellTopic"><br><em>Note:</em></td>
		<td valign="top">
			<hr size="1" />
			<div class="CellNote">The information on this page applies to Products and Pages only.
			For information on automated XML downloads of Orders, see
			<a href="orders.download.format.xml-auto.html">Automated XML Orders Download</a>.</div>

			<hr size="1" />
		</td>
	</tr>
</table>

<p class="Body">There are three CGI programs used for the different tasks of downloading,
uploading, and publishing the store.  Each of these CGIs can be called from an automated script
or manually, using a standard HTTP POST function.  The following example demonstrates a typical
URL used to invoke one of the scripts:</p>

<blockquote>
	<span class="Code" style="white-space: nowrap;">http://myhost.mydomain/cgi-path/db_xml.cgi?clientApp=1&amp;dbname=products&amp;fieldmap=inventory</span>

</blockquote>

<p class="Body">In the example above, <i>mystore.domain</i> represents the domain name of the
store, and <i>cgi-path</i> is the path to the ShopSite back-office CGI directory.  In this
example, we are using the <i>db_xml.cgi</i> program, and we are passing the following options:
<i>clientApp=1</i>, <i>dbname=products</i>, and <i>fieldmap=inventory</i>.  The meaning and
use of the options is explained below.</p>

<table width="90%" border="0" cellpadding="5" cellspacing="0">
	<tr>
		<td valign="top" width="50" class="CellTopic"><br><em>Note:</em></td>
		<td valign="top">
			<hr size="1" />
			<div class="CellNote">Any spaces in values for any options should be replaced with a
			plus sign (+) when included in a URL.  For example, the value <i>Field Name</i> would
			be represented as <i>Field</i>+<i>Name</i>:<br>

			
			<blockquote>
				<span class="Code">.&nbsp;.&nbsp;./dbupload.cgi?clientApp=1&amp;dbname=products&amp;uniqueName=File+Name</span>
			</blockquote></div>
			<hr size="1" />
		</td>
	</tr>

</table>

<h5 class="Heading4">Downloading Data</h5>

<p class="Body">The database download program allows you to export all or part of a database in
XML format.  The available options allow you to specify which database to export, what format to
use, and which data you want.</p>

<p class="Body"><span class="Strong">Program Name:</span></p>

<blockquote>
	<p class="Body"><span class="Code">db_xml.cgi</span></p>
</blockquote>

<p class="Body"></p>

<p class="Body"><span class="Strong">Options</span></p>
<blockquote>
	<FORM method="POST" target="result" action="">
           <table width="90%">
		<tr>
			<th class="option">Option</th>
			<th class="description">Description</th>
			<th class="values">Values</th>
			<th class="input">P<br>A<br>S<br>S<br>E<br>D<br>?</th>
			<th class="input">Input</th>
		</tr>
		<tr>
			<td class="option"><span class="Code">clientApp</span></td>
			<td class="description"><span class="Strong">Required</span>. Identifies the client application
			interface version.</td>
			<td class="values">1</td>
			<td class="input"><INPUT type="checkbox" checked="true" disabled="true" name="required"></td>
			<td class="input" ><INPUT align="right" readonly="true" type="text" name="clientApp" value="1" size="5" maxlength="5">
			</td>
		</tr>
		<tr>
			<td class="option"><span class="Code">dbname</span></td>
			<td class="description"><span class="Strong">Required</span>.  The name of the database that is being
			accessed.</td>
			<td class="values">pages<br>
			products</td>
			<td class="input"><INPUT type="checkbox" checked="true" disabled="true" name="required"></td>
			<td class="input">
				<SELECT name="dbname">
					<OPTION value="pages">pages</OPTION>
					<OPTION value="products">products</OPTION>
				</SELECT>
			</td>
		</tr>
		<tr>
			<td class="option"><span class="Code">version</span></td>
			<td class="description">Optional.  The XML format version (based on ShopSite implementation).  Using
			this option will ensure that your application downloads a compatible version of the database, in case
			future ShopSite versions require changes to the XML format.</td>
			<td class="values">7.1&nbsp;(default)</td>
			<td class="input"><INPUT type="checkbox" name="option_1"></td>
			<td class="input">
			<INPUT name="version" type="text" value="7.1" maxlength="5" size="5" align="right" >
			</td>
		</tr>
		<tr>
			<td class="option"><span class="Code">fields</span></td>

			<td class="description">Optional.  A list of fields to download, delimited by the pipe (|) character.
			For example: <span class="Code">fields=|fieldname_1|fieldname_2|fieldname_3|</span></td>
			<td class="values">All&nbsp;(default)<br>
			<i>any valid field from specified database</i></td>
			<td class="input"><INPUT type="checkbox" name="option_2"></td>
			<td class="input">
				<TEXTAREA name="fields" rows="3" cols="20"></TEXTAREA>
			</td>
		</tr>
		<tr>
			<td class="option"><span class="Code">fieldmap</span></td>

			<td class="description">Optional. A fieldmap lists field number and ID pairs that associate the data in
			the XML output file with the store data.  You can create fieldmaps using the tool
			provided in the Database Download area in the ShopSite back office (click on
			<span class="Strong">Utilities</span> &gt; <span class="Strong">Database</span> &gt;
			<span class="Strong">Upload/Download</span>, then select the database you want to
			create a fieldmap for, and click <span class="Strong">Download</span>.  In the 
			<i>Download fields</i> section, find the <i>Use field map</i> option, select 
			<span class="Strong">&lt;New&gt;</span> from the pull-down menu, then click on 
			<span class="Strong">Change</span>.)</td>

			<td class="values"><i>any existing fieldmap name</i></td>
			<td class="input"><INPUT type="checkbox" name="option_3"></td>
			<td class="input">
				<TEXTAREA name="fieldmap" rows="3" cols="20"></TEXTAREA>
			</td>
		</tr>
	</table>
	  <INPUT type="submit" name="display_vars" value="display vars">
      <INPUT type="submit" name="display_env" value="display environment">
      <INPUT type="submit" name="display_code" value="display source">
      <INPUT type="submit" name="dbdown_display_http" value="invoke cgi">
      <INPUT name="cgi_string" size="60" type="text" value="http://$$$HTTP_HOST/cgi-bin/ss/db_xml.cgi" maxlength="60">
 
         </FORM>
</blockquote>


<h5 class="Heading4">Uploading Data</h5>

<p class="Body">The upload program can be used to upload
MIME encoded XML files or to import
an XML file that has already been uploaded to ShopSite's HTML output directory.  For very
large databases (usually over 10,000 records), you can break up the upload into several
files and upload them in batches.</p>

<p class="Body"><span class="Strong">Program Name:</span></p>

<blockquote>
	<p class="Body"><span class="Code">dbupload.cgi</span></p>
</blockquote>

<p class="Body"><span class="Strong">Options</span></p>
<blockquote>
<FORM method="POST" target="result" action="">
	<table width="90%">
		<tr>

			<th class="option">Option</th>
			<th class="description">Description</th>
			<th class="values">Values</th>
			<th class="input">P<br>A<br>S<br>S<br>E<br>D<br>?</th>
			<th class="input">Input</th>
		</tr>
		<tr>
			<td class="option"><span class="Code">clientApp</span></td>
			<td class="description"><span class="Strong">Required</span>. Identifies the client application
			interface version.</td>
			<td class="values">1</td>
			<td class="input"><INPUT type="checkbox" checked="true"  disabled="true" name="required"></td>
			<td class="input">
				<INPUT name="clientApp" readonly align="right" type="text" value="1" size="5" maxlength="5">
			</td>
		</tr>
		<tr>
			<td class="option"><span class="Code">dbname</span></td>
			<td class="description"><span class="Strong">Required</span>. The name of the database
			that you are uploading.</td>
			<td class="values">pages<br>
			products</td>
			<td class="input"><INPUT type="checkbox" checked="true"  disabled="true" name="required"></td>
			<td class="input">
				<SELECT name="dbname">
					<OPTION value="pages">pages</OPTION>
					<OPTION value="products">products</OPTION>
				</SELECT>
			</td>
		</tr>
		<tr>
			<td class="option"><span class="Code">filename</span></td>
			<td class="description">Optional.  Used if the XML file was previously uploaded to the
			ShopSite HTML Output directory, to indicate the name of the file to import.</td>
			<td class="values"><i>filename</i></td>
			<td class="input"><INPUT type="checkbox" name="option_1"></td>
			<td class="input"><INPUT type="text" name="filename">
			</td>
		</tr>

		<tr>
			<td class="option"><span class="Code">uniqueName</span></td>
			<td class="description">Optional.  The unique database key field name.  This value
			is used to match records in the uploaded XML data to records in an existing
			ShopSite database. The (none) option turns off record matching, which allows duplicate
			entries in your database (new records with the same name as an existing record will be
			uploaded as a separate record, rather than updating the existing record).</td>
			<td class="values">Name<br>
			SKU&nbsp;<i>(Products)</i><br>
			File+Name&nbsp;<i>(Pages)</i><br>
			(none)</td>
			<td class="input"><INPUT type="checkbox" name="option_2"></td>
			<td class="input"><INPUT type="text" name="uniqueName"></td>
		</tr>
		<tr>
			<td class="option"><span class="Code">checkpoint</span></td>
			<td class="description">Optional.  For large databases, specify the interval
			between record checkpoints.</td>
			<td class="values">500&nbsp;(default)<br>
			<i>any number</i></td>
			<td class="input"><INPUT type="checkbox" name="option_3"></td>
			<td class="input"><INPUT type="text" name="checkpoint" size="10" maxlength="10"></td>
		</tr>
		<tr>
			<td class="option"><span class="Code">newRecords</span></td>
			<td class="description">Optional.  If the XML upload contains new products or pages,
			setting this to "no" will ignore those rows during the import process.</td>
			<td class="values">yes&nbsp;(default)<br>
			no</td>
			<td class="input"><INPUT type="checkbox" name="option_4"></td>
			<td class="input"><FONT color="Red">
				<SELECT name="newRecords">
					<OPTION value="yes">yes</OPTION>
					<OPTION value="no">no</OPTION>		
				</SELECT></FONT>
			</td>
		</tr>
		<tr>
			<td class="option"><span class="Code">use_optimizer</span></td>
			<td class="description">Optional.  Setting this option to <em>yes</em> will run the
			link optimizer during the upload process.  The optimizer will slow down the upload, but
			on very large databases (more than 100,000 records) the decreased time required to link
			records in the database makes the trade-off worth while.</td>
			<td class="values">no&nbsp;(default)<br>
			yes</td>
			<td class="input"><INPUT type="checkbox" name="option_5"></td>
			<td class="input">
				<SELECT name="use_optimizer">
					<OPTION value="yes">yes</OPTION>
					<OPTION value="no">no</OPTION>		
				</SELECT>
				</td>
		</tr>
		<tr>
			<td class="option"><span class="Code">defer_linking</span></td>
			<td class="description">Optional.  When uploading large databases in batches,
			setting this to "yes" for all but the last file in the batch will postpone record
			linking until the full database has been uploaded.</td>
			<td class="values">no&nbsp;(default)<br>
			yes</td>
			<td class="input"><INPUT type="checkbox" name="option_6"></td>
			<td class="input">
				<SELECT name="newRecords">
					<OPTION value="yes">yes</OPTION>
					<OPTION value="no">no</OPTION>		
				</SELECT>
			</td>
		</tr>
		<tr>
			<td class="option"><span class="Code">restart</span></td>
			<td class="description">Optional.  If an upload times-out or is interrupted, use the
			restart option to start the upload again from where it left off.</td>
			<td class="values">1</td>
			<td class="input"><INPUT type="checkbox" name="option_7"></td>
			<td class="input">
				<INPUT type="text" name="restart" value="1" size="4" maxlength="4" align="right">
			</td>
		</tr>
	</table>
	  <INPUT type="submit" name="display_vars" value="display vars">
      <INPUT type="submit" name="display_env" value="display environment">
      <INPUT type="submit" name="display_code" value="display source">
      <INPUT type="submit" name="dbup_display_http" value="invoke cgi">
      <INPUT name="cgi_string" size="60" type="text" value="http://$$$HTTP_HOST/cgi-bin/ss/dbupload.cgi" maxlength="60">
      </FORM>

</blockquote>

<h5 class="Heading4">Publishing Data</h5>

<p class="Body">After new store data has been imported into ShopSite, it is necessary to regenerate
the store pages with the new information.  The same options available from the Back Office 
<span class="Strong">Publish</span> tool can be included in an automated publish.</p>

<p class="Body"><span class="Strong">Program Name:</span></p>

<blockquote>

	<p class="Body"><span class="Code">generate.cgi</span></p>
</blockquote>

<p class="Body"><span class="Strong">Options</span></p>
<blockquote>
<FORM method="POST" target="result" action="">
	<table width="90%">
		<tr>
			<th class="option">Option</th>
			<th class="description">Description</th>

			<th class="values">Values</th>
			<th class="input">P<br>A<br>S<br>S<br>E<br>D<br>?</th>
			<th class="input">Input</th>
		</tr>
		<tr>
			<td class="option"><span class="Code">clientApp</span></td>
			<td class="description"><span class="Strong">Required</span>. Identifies the client application
			interface version.</td>
			<td class="values">1</td>
			<td class="input"><INPUT type="checkbox" disabled checked name="required"></td>
			<td class="input">1</td>
		</tr>
		<tr>
			<td class="option"><span class="Code">htmlpages</span></td>
			<td class="description">Optional.  If included, HTML pages will be generated.</td>
			<td class="values">1</td>
			<td class="input"><INPUT type="checkbox" name="option_1"></td>
			<td class="input">1</td>
		</tr>
		<tr>

			<td class="option"><span class="Code">custompages</span></td>
			<td class="description">Optional.  If included, Custom pages will be generated.</td>
			<td class="values">1</td>
			<td class="input"><INPUT type="checkbox" name="option_2"></td>
			<td class="input">1</td>
		</tr>
		<tr>
			<td class="option"><span class="Code">index</span></td>
			<td class="description">Optional.  If included, the search index will be updated.</td>

			<td class="values">1</td>
			<td class="input"><INPUT type="checkbox" name="option_3"></td>
			<td class="input">1</td>
		</tr>
		<tr>
			<td class="option"><span class="Code">regen</span></td>
			<td class="description">Optional.  If included, all store content will be regenerated.
			If left out, only the content that has changed since the last publish will be regenerated.</td>
			<td class="values">1</td>
			<td class="input"><INPUT type="checkbox" name="option_4"></td>
			<td class="input">1</td>
		</tr>

	</table>
	<INPUT type="submit" name="display_vars" value="display vars">
	<INPUT type="submit" name="display_env" value="display environment">
	<INPUT type="submit" name="display_code" value="display source">
	<INPUT type="submit" name="dbgen_display_http" value="invoke cgi">
	<INPUT name="cgi_string" size="60" type="text" value="http://$$$HTTP_HOST/cgi-bin/ss/generate.cgi" maxlength="120">
	</FORM>

</blockquote>

<p class="Body">If a publish times out before completing, you can call <span class="Code">generate.cgi</span>
with the same options as before, and the publish will restart from where it left off.</p>

<!-- START OF SHOPSITE FOOTER -->
<hr width="95%" color="#000099" noshade>
<table align="center" width="95%" border="0" cellspacing="0" cellpadding="0">
  <tr>
    <td valign="top" align="left"><font size="1" face="Verdana, Arial, Helvetica, sans-serif">

      ShopSite Help and Resource Center<br>
      Last updated: January 13, 2005<br>
      <a href="feedback.html">Give Feedback</a>
    </td>
    <td valign="top" align="right"><font size="1" face="Verdana, Arial, Helvetica, sans-serif">
      <img src="/shopsite-small.gif"><br>
      &#169; 2005, <a href="http://www.shopsite.com" target="_blank">ShopSite, Inc.</a><br>

      http://www.shopsite.com
    </td>
   </tr>
   </font>
</table>
<script language="JavaScript">
if (document.all) {
  onLoad();
}
</script>
<!-- END OF SHOPSITE FOOTER -->
THE-END

s/\$\$\$HTTP_HOST/$ENV{'HTTP_HOST'}/eg;
print $_;
}

#--------------------------
# routine: print_source
#
# This routine will print out the
# source to this CGI script.
#
sub print_source {
  $pname = $PROGRAM_NAME;
  open(PFILE, $pname) || die("Could not open $pname\n");
  while($line = <PFILE>) {
    print $line;
  }
  close(PFILE);
}

#--------------------------
# routine: print_button
#
# This routine constructs the HTML form button
# which will be used to submit the appropriate
# CGI/"QUERY_STRING" to the ShopSite store.
#

sub print_button
{
	my $q = shift;
	print "<A href=\"$q\">$q</A>";
}


